<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class HighLight extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "highlight";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[highlight]Sample text[/highlight]\n[highlight color=\"#fff\" bg=\"#000\"]Sample Text[/highlight]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/		
	var $sample_attributes = array(
		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin color"
		),
		array(
			"name"		=> "bg",
			"hint"		=> "#hexcode, default: skin color"
		),

		array(
			"name"		=> "size",
			"hint"		=> "value (px|em|rem), default: inherits element size. If no unit is specified px is used"
		),

		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization"
		)	
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {
		$this->loadTemplate();

		$css = array();
		$style = array();
		$vars = $data["vars"];

		if ($vars["color"]) {
			$style[] = $this->getBackground($vars["color"] , "color")["bg_style"];
		}

		if ($vars["bg"]) {
			$css[] = "highlight-set-bg";			
			$style[] = $this->getBackground($vars["bg"] , "background")["bg_style"];
		}

		if ($vars["size"]) {
			$style[] = "font-size:" . $this->getSize($vars["size"]);
		}

		if ($vars["class"]) { $css[] = $this->CSSClass($vars["class"]); }

		return array(
			"content"	=> $this->tpl->blockReplace(
					"Main",
					array(
						"css"		=> implode(" " , $css),
						"style"		=> implode(" " , $style),
						"content"	=> $data["vars"]["content"],
						"before"	=> $data["before"],
						"after"		=> $data["after"],
					)
				),
			"before"	=> "",
			"after"		=> "",
		);

	}
	
	
}